/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.pikachu.mod.illager_more.client.models.illager.BlastionerModel;
import com.pikachu.mod.illager_more.entities.BlastionerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.renderers.geo.ExtendedGeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;

public class BlastionerEntityRenderer<T extends BlastionerEntity>
extends ExtendedGeoEntityRenderer<T> {
    protected ItemStack mainHandItem;
    protected ItemStack offHandItem;
    protected ItemStack helmetItem;
    protected ItemStack chestplateItem;
    protected ItemStack leggingsItem;
    protected ItemStack bootsItem;

    public BlastionerEntityRenderer(EntityRendererProvider.Context renderManager, String geoNames, String animationNames, String texturesNames) {
        super(renderManager, new BlastionerModel(geoNames, animationNames, texturesNames));
    }

    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.isArmorBone(bone)) {
            bone.setHidden(true);
        }
        if (bone.getName().equals("headWear") && !(this.helmetItem.m_41720_() instanceof ArmorItem)) {
            stack.m_85836_();
            stack.m_85845_(Vector3f.f_122223_.m_122240_(0.0f));
            stack.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
            stack.m_85845_(Vector3f.f_122227_.m_122240_(0.0f));
            stack.m_85837_(0.0, 1.75, 0.0);
            stack.m_85841_(0.6f, 0.6f, 0.6f);
            Minecraft.m_91087_().m_91291_().m_174269_(this.helmetItem, ItemTransforms.TransformType.HEAD, packedLightIn, packedOverlayIn, stack, this.rtb, 0);
            stack.m_85849_();
            bufferIn = this.rtb.m_6299_(RenderType.m_110473_((ResourceLocation)this.whTexture));
        }
        alpha = 1.0f;
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Nullable
    protected ResourceLocation getTextureForBone(String boneName, T animatable) {
        return null;
    }

    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().startsWith("armor");
    }

    public void renderEarly(T animatable, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float partialTicks) {
        super.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, partialTicks);
        this.mainHandItem = animatable.m_6844_(EquipmentSlot.MAINHAND);
        this.offHandItem = animatable.m_6844_(EquipmentSlot.OFFHAND);
        this.helmetItem = animatable.m_6844_(EquipmentSlot.HEAD);
        this.chestplateItem = animatable.m_6844_(EquipmentSlot.CHEST);
        this.leggingsItem = animatable.m_6844_(EquipmentSlot.LEGS);
        this.bootsItem = animatable.m_6844_(EquipmentSlot.FEET);
    }

    protected ItemStack getHeldItemForBone(String boneName, T currentEntity) {
        return switch (boneName) {
            case "bipedHandLeft" -> this.offHandItem;
            case "bipedHandRight" -> this.mainHandItem;
            default -> null;
        };
    }

    protected ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        return switch (boneName) {
            case "bipedHandLeft", "bipedHandRight", "bipedHandRight2" -> ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            default -> ItemTransforms.TransformType.NONE;
        };
    }

    protected void preRenderItem(PoseStack stack, ItemStack item, String boneName, T currentEntity, IBone bone) {
        if (item == this.mainHandItem || item == this.offHandItem) {
            stack.m_85841_(1.1f, 1.1f, 1.1f);
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            boolean shieldFlag = item.m_41720_() instanceof ShieldItem;
            if (item == this.mainHandItem) {
                if (shieldFlag) {
                    stack.m_85837_(0.0, 0.125, -0.25);
                }
            } else if (shieldFlag) {
                stack.m_85837_(-0.15, 0.125, 0.05);
                stack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            }
        }
    }

    protected void postRenderItem(PoseStack matrixStack, ItemStack item, String boneName, T currentEntity, IBone bone) {
    }

    @Nullable
    protected ItemStack getArmorForBone(String boneName, T currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return this.bootsItem;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return this.leggingsItem;
            }
            case "armorBipedBody": 
            case "armorBipedRightArm": 
            case "armorBipedLeftArm": 
            case "armorIllagerRightArm": 
            case "armorIllagerLeftArm": {
                return this.chestplateItem;
            }
            case "armorBipedHead": {
                return this.helmetItem;
            }
        }
        return null;
    }

    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, T currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return EquipmentSlot.FEET;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return EquipmentSlot.LEGS;
            }
            case "armorBipedLeftArm": 
            case "armorIllagerLeftArm": {
                return EquipmentSlot.MAINHAND;
            }
            case "armorBipedRightArm": 
            case "armorIllagerRightArm": {
                return EquipmentSlot.OFFHAND;
            }
            case "armorBipedBody": {
                return EquipmentSlot.CHEST;
            }
            case "armorBipedHead": {
                return EquipmentSlot.HEAD;
            }
        }
        return null;
    }

    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorBipedModel) {
        switch (name) {
            case "armorBipedLeftFoot": 
            case "armorBipedLeftLeg": {
                return armorBipedModel.f_102814_;
            }
            case "armorBipedRightFoot": 
            case "armorBipedRightLeg": {
                return armorBipedModel.f_102813_;
            }
            case "armorBipedRightArm": 
            case "armorIllagerRightArm": {
                return armorBipedModel.f_102811_;
            }
            case "armorBipedLeftArm": 
            case "armorIllagerLeftArm": {
                return armorBipedModel.f_102812_;
            }
            case "armorBipedBody": {
                return armorBipedModel.f_102810_;
            }
            case "armorBipedHead": {
                return armorBipedModel.f_102808_;
            }
        }
        return null;
    }

    protected BlockState getHeldBlockForBone(String boneName, T currentEntity) {
        return null;
    }

    protected void preRenderBlock(PoseStack stack, BlockState block, String boneName, T currentEntity) {
    }

    protected void postRenderBlock(PoseStack stack, BlockState block, String boneName, T currentEntity) {
    }

    protected void setLimbBoneVisible(GeoArmorRenderer<? extends GeoArmorItem> armorRenderer, ModelPart limb, HumanoidModel<?> armorModel, EquipmentSlot slot) {
        if (limb == armorModel.f_102808_ || limb == armorModel.f_102809_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.headBone).setHidden(false);
        } else if (limb == armorModel.f_102810_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(true);
        } else if (limb == armorModel.f_102812_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(true);
        } else if (limb == armorModel.f_102814_) {
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.leftBootBone : armorRenderer.leftLegBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.rightBootBone : armorRenderer.rightLegBone).setHidden(true);
        } else if (limb == armorModel.f_102811_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(false);
        } else if (limb == armorModel.f_102813_) {
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.rightBootBone : armorRenderer.rightLegBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.leftBootBone : armorRenderer.leftLegBone).setHidden(true);
        }
    }
}

